/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.BigNodesLabelHandler;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BigNodesPreProcessor
implements ILayoutProcessor<LGraph> {
    private static final double MIN_WIDTH = 50.0;
    private LGraph layeredGraph;
    private int dummyID = 0;
    private double spacing = 0.0;
    private Direction direction = Direction.UNDEFINED;

    public void process(LGraph theLayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Big nodes pre-processing", 1.0f);
        this.layeredGraph = theLayeredGraph;
        List<LNode> nodes = this.layeredGraph.getLayerlessNodes();
        int counter = 0;
        for (LNode node : nodes) {
            node.id = counter++;
        }
        this.spacing = (Double)this.layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.direction = (Direction)this.layeredGraph.getProperty(LayeredOptions.DIRECTION);
        this.dummyID = nodes.size();
        double minWidth = 3.4028234663852886E38;
        for (LNode node : nodes) {
            if (node.getType() != LNode.NodeType.NORMAL || !(node.getSize().x < minWidth)) continue;
            minWidth = node.getSize().x;
        }
        minWidth = Math.max(50.0, minWidth);
        ArrayList bigNodes = Lists.newArrayList();
        double threshold = minWidth + this.spacing;
        for (Object node : nodes) {
            if (node.getType() != LNode.NodeType.NORMAL || !(node.getSize().x > threshold)) continue;
            int parts = 1;
            double chunkWidth = node.getSize().x;
            while (chunkWidth > minWidth) {
                chunkWidth = (node.getSize().x - (double)(++parts - 1) * this.spacing) / (double)parts;
            }
            bigNodes.add(new BigNode((LNode)((Object)node), parts, chunkWidth));
        }
        for (Object node : bigNodes) {
            if (!this.isProcessorApplicable(((BigNode)node).node)) continue;
            ((BigNode)node).process();
        }
        monitor.done();
    }

    private boolean isProcessorApplicable(LNode node) {
        if (node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_RATIO || node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS) {
            for (LPort port : node.getPorts()) {
                if (port.getSide() != PortSide.NORTH && port.getSide() != PortSide.SOUTH) continue;
                return false;
            }
        }
        if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            for (LPort p : node.getPorts(PortSide.EAST)) {
                if (p.getIncomingEdges().isEmpty()) continue;
                return false;
            }
        }
        for (LEdge edge : node.getOutgoingEdges()) {
            if (!((Object)((Object)edge.getSource().getNode())).equals((Object)edge.getTarget().getNode())) continue;
            return false;
        }
        return true;
    }

    private class BigNode {
        private LNode node;
        private int chunks;
        private double minWidth;
        private ArrayList<LNode> dummies = Lists.newArrayList();

        public BigNode(LNode node, int chunks, double minWidth) {
            this.node = node;
            this.chunks = chunks;
            this.minWidth = minWidth;
        }

        public void process() {
            ArrayList eastPorts = Lists.newArrayList();
            for (LPort port : this.node.getPorts()) {
                if (port.getSide() != PortSide.EAST) continue;
                eastPorts.add(port);
            }
            if (BigNodesPreProcessor.this.direction == Direction.RIGHT && !((PortConstraints)this.node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                for (LEdge e : this.node.getOutgoingEdges()) {
                    eastPorts.add(e.getSource());
                }
            }
            double originalWidth = this.node.getSize().x;
            this.node.setProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE, Float.valueOf((float)this.node.getSize().x));
            this.node.getSize().x = this.minWidth;
            this.node.setProperty(InternalProperties.BIG_NODE_INITIAL, true);
            this.dummies.add(this.node);
            LNode start = this.node;
            originalWidth -= this.minWidth;
            int tmpChunks = this.chunks;
            while (tmpChunks > 1) {
                double dummyWidth = Math.min(originalWidth, this.minWidth);
                start = this.introduceDummyNode(start, dummyWidth);
                BigNodesPreProcessor.this.layeredGraph.getLayerlessNodes().add(start);
                --tmpChunks;
                originalWidth -= this.minWidth + BigNodesPreProcessor.this.spacing;
            }
            BigNodesLabelHandler.handle(this.node, this.dummies, this.minWidth);
            for (LPort port : eastPorts) {
                this.node.getPorts().remove((Object)port);
                port.setNode(start);
            }
        }

        private LNode introduceDummyNode(LNode src, double width) {
            LNode dummy = new LNode(BigNodesPreProcessor.this.layeredGraph);
            dummy.setType(LNode.NodeType.BIG_NODE);
            dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (PortConstraints)src.getProperty(LayeredOptions.PORT_CONSTRAINTS));
            dummy.setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, (EnumSet)src.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT));
            BigNodesPreProcessor bigNodesPreProcessor = BigNodesPreProcessor.this;
            int n = bigNodesPreProcessor.dummyID;
            bigNodesPreProcessor.dummyID = n + 1;
            dummy.id = n;
            this.dummies.add(dummy);
            dummy.getSize().y = src.getSize().y;
            dummy.getSize().x = width;
            LPort outPort = new LPort();
            outPort.setSide(PortSide.EAST);
            outPort.setNode(src);
            outPort.getPosition().x = dummy.getSize().x;
            outPort.getPosition().y = dummy.getSize().y / 2.0;
            LPort inPort = new LPort();
            inPort.setSide(PortSide.WEST);
            inPort.setNode(dummy);
            inPort.getPosition().y = dummy.getSize().y / 2.0;
            inPort.getPosition().x = -inPort.getSize().x;
            LEdge edge = new LEdge();
            edge.setSource(outPort);
            edge.setTarget(inPort);
            return dummy;
        }
    }
}

