/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import java.util.EnumSet;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.PortContext;

public final class NodeLabelAndSizeUtilities {
    private static final EnumSet<SizeConstraint> EFFECTIVELY_FIXED_SIZE_CONSTRAINTS = EnumSet.of(SizeConstraint.PORT_LABELS);

    private NodeLabelAndSizeUtilities() {
    }

    public static void setupMinimumClientAreaSize(NodeContext nodeContext) {
        KVector minSize = NodeLabelAndSizeUtilities.getMinimumClientAreaSize(nodeContext);
        if (minSize != null) {
            nodeContext.insideNodeLabelContainer.setCenterCellMinimumSize(minSize);
        }
    }

    public static void setupNodePaddingForPortsWithOffset(NodeContext nodeContext) {
        ElkPadding nodeCellPadding = nodeContext.nodeContainer.getPadding();
        for (PortContext portContext : nodeContext.portContexts.values()) {
            double portBorderOffset;
            if (!portContext.port.hasProperty(CoreOptions.PORT_BORDER_OFFSET) || !((portBorderOffset = portContext.port.getProperty(CoreOptions.PORT_BORDER_OFFSET).doubleValue()) < 0.0)) continue;
            switch (portContext.port.getSide()) {
                case NORTH: {
                    nodeCellPadding.top = Math.max(nodeCellPadding.top, -portBorderOffset);
                    break;
                }
                case SOUTH: {
                    nodeCellPadding.bottom = Math.max(nodeCellPadding.bottom, -portBorderOffset);
                    break;
                }
                case EAST: {
                    nodeCellPadding.right = Math.max(nodeCellPadding.right, -portBorderOffset);
                    break;
                }
                case WEST: {
                    nodeCellPadding.left = Math.max(nodeCellPadding.left, -portBorderOffset);
                }
            }
        }
    }

    public static void offsetSouthernPortsByNodeSize(NodeContext nodeContext) {
        double nodeHeight = nodeContext.nodeSize.y;
        for (PortContext portContext : nodeContext.portContexts.get((Object)PortSide.SOUTH)) {
            KVector portPosition = portContext.portPosition;
            portPosition.y += nodeHeight;
        }
    }

    public static void setNodePadding(NodeContext nodeContext) {
        if (!nodeContext.sizeOptions.contains((Object)SizeOptions.COMPUTE_PADDING)) {
            return;
        }
        ElkRectangle nodeRect = nodeContext.nodeContainer.getCellRectangle();
        ElkRectangle clientArea = nodeContext.insideNodeLabelContainer.getCenterCellRectangle();
        ElkPadding nodePadding = new ElkPadding();
        nodePadding.left = clientArea.x - nodeRect.x;
        nodePadding.top = clientArea.y - nodeRect.y;
        nodePadding.right = nodeRect.x + nodeRect.width - (clientArea.x + clientArea.width);
        nodePadding.bottom = nodeRect.y + nodeRect.height - (clientArea.y + clientArea.height);
        nodeContext.node.setPadding(nodePadding);
    }

    public static void applyStuff(NodeContext nodeContext) {
        nodeContext.applyNodeSize();
        nodeContext.portContexts.values().stream().forEach(pc -> pc.applyPortPosition());
    }

    public static KVector getMinimumClientAreaSize(NodeContext nodeContext) {
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.MINIMUM_SIZE) && nodeContext.sizeOptions.contains((Object)SizeOptions.MINIMUM_SIZE_ACCOUNTS_FOR_PADDING)) {
            return NodeLabelAndSizeUtilities.getMinimumNodeOrClientAreaSize(nodeContext);
        }
        return null;
    }

    public static KVector getMinimumNodeSize(NodeContext nodeContext) {
        if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.MINIMUM_SIZE) && !nodeContext.sizeOptions.contains((Object)SizeOptions.MINIMUM_SIZE_ACCOUNTS_FOR_PADDING)) {
            return NodeLabelAndSizeUtilities.getMinimumNodeOrClientAreaSize(nodeContext);
        }
        return null;
    }

    public static KVector getMinimumNodeOrClientAreaSize(NodeContext nodeContext) {
        KVector minSize = new KVector(nodeContext.node.getProperty(CoreOptions.NODE_SIZE_MINIMUM));
        if (nodeContext.sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
            if (minSize.x <= 0.0) {
                minSize.x = 20.0;
            }
            if (minSize.y <= 0.0) {
                minSize.y = 20.0;
            }
        }
        return minSize;
    }

    public static boolean areSizeConstraintsFixed(NodeContext nodeContext) {
        return nodeContext.sizeConstraints.isEmpty() || nodeContext.sizeConstraints.equals(EFFECTIVELY_FIXED_SIZE_CONSTRAINTS);
    }

    public static boolean effectiveCompoundNodeMode(PortContext portContext) {
        if (!portContext.parentNodeContext.treatAsCompoundNode) {
            return false;
        }
        if (portContext.parentNodeContext.node.getProperty(CoreOptions.PORT_LABELS_NEXT_TO_PORT_IF_POSSIBLE).booleanValue()) {
            return portContext.port.hasCompoundConnections();
        }
        return true;
    }
}

