/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.recthull;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.compaction.recthull.Point;
import org.eclipse.elk.alg.layered.compaction.recthull.Scanline;
import org.eclipse.elk.core.math.ElkRectangle;

public final class RectilinearConvexHull {
    private List<Point> hull = Lists.newArrayList();
    private Point xMax1 = null;
    private Point xMax2 = null;
    private Point xMin1 = null;
    private Point xMin2 = null;
    private Point yMax1 = null;
    private Point yMax2 = null;
    private Point yMin1 = null;
    private Point yMin2 = null;
    private static final boolean DEBUG = false;
    private static final Comparator<Point> RIGHT_HIGH_FIRST = (p1, p2) -> {
        if (p1.x == p2.x) {
            return Double.compare(p2.y, p1.y);
        }
        return Double.compare(p1.x, p2.x);
    };
    private static final Comparator<Point> RIGHT_LOW_FIRST = (p1, p2) -> {
        if (p1.x == p2.x) {
            return Double.compare(p1.y, p2.y);
        }
        return Double.compare(p1.x, p2.x);
    };
    private static final Comparator<Point> LEFT_HIGH_FIRST = (p1, p2) -> {
        if (p1.x == p2.x) {
            return Double.compare(p2.y, p1.y);
        }
        return Double.compare(p2.x, p1.x);
    };
    private static final Comparator<Point> LEFT_LOW_FIRST = (p1, p2) -> {
        if (p1.x == p2.x) {
            return Double.compare(p1.y, p2.y);
        }
        return Double.compare(p2.x, p1.x);
    };
    private static final Comparator<Point> RIGHT_SPECIAL_ORDER = (p1, p2) -> {
        if (p1.x == p2.x) {
            if (p1.quadrant == p2.quadrant || Point.Quadrant.isBothLeftOrBothRight(p1.quadrant, p2.quadrant)) {
                int val;
                int n = val = p1.quadrant.isLeft() ? 1 : -1;
                if (p1.convex && !p2.convex) {
                    return val;
                }
                if (!p1.convex && p2.convex) {
                    return -val;
                }
            }
            return Integer.compare(p1.quadrant.ordinal(), p2.quadrant.ordinal());
        }
        return Double.compare(p1.x, p2.x);
    };

    private RectilinearConvexHull() {
    }

    public static RectilinearConvexHull of(Iterable<Point> points) {
        RectilinearConvexHull rch = new RectilinearConvexHull();
        for (Point p : points) {
            if (rch.xMax1 == null || p.x >= rch.xMax1.x) {
                rch.xMax2 = rch.xMax1;
                rch.xMax1 = p;
            }
            if (rch.xMin1 == null || p.x <= rch.xMin1.x) {
                rch.xMin2 = rch.xMin1;
                rch.xMin1 = p;
            }
            if (rch.yMax1 == null || p.y >= rch.yMax1.y) {
                rch.yMax2 = rch.yMax1;
                rch.yMax1 = p;
            }
            if (rch.yMin1 != null && !(p.y <= rch.yMin1.y)) continue;
            rch.yMin2 = rch.yMin1;
            rch.yMin1 = p;
        }
        MaximalElementsEventHandler q1 = new MaximalElementsEventHandler(Point.Quadrant.Q1);
        Scanline.execute(points, RIGHT_LOW_FIRST, q1);
        MaximalElementsEventHandler q4 = new MaximalElementsEventHandler(Point.Quadrant.Q4);
        Scanline.execute(points, RIGHT_HIGH_FIRST, q4);
        MaximalElementsEventHandler q2 = new MaximalElementsEventHandler(Point.Quadrant.Q2);
        Scanline.execute(points, LEFT_LOW_FIRST, q2);
        MaximalElementsEventHandler q3 = new MaximalElementsEventHandler(Point.Quadrant.Q3);
        Scanline.execute(points, LEFT_HIGH_FIRST, q3);
        RectilinearConvexHull.addConcaveCorners(q1.points, Point.Quadrant.Q1);
        RectilinearConvexHull.addConcaveCorners(q2.points, Point.Quadrant.Q2);
        RectilinearConvexHull.addConcaveCorners(q3.points, Point.Quadrant.Q3);
        RectilinearConvexHull.addConcaveCorners(q4.points, Point.Quadrant.Q4);
        rch.getHull().clear();
        rch.getHull().addAll(q1.points);
        rch.getHull().addAll(Lists.reverse(q2.points));
        rch.getHull().addAll(q3.points);
        rch.getHull().addAll(Lists.reverse(q4.points));
        return rch;
    }

    public List<Point> getHull() {
        return this.hull;
    }

    public List<ElkRectangle> splitIntoRectangles() {
        RectangleEventHandler handler = new RectangleEventHandler();
        Scanline.execute(this.hull, RIGHT_SPECIAL_ORDER, handler);
        if (handler.queued != null) {
            handler.rects.add(handler.queued);
        }
        return handler.rects;
    }

    private static void addConcaveCorners(List<Point> pts, Point.Quadrant q) {
        ListIterator<Point> pIt = pts.listIterator();
        Point last = pIt.next();
        while (pIt.hasNext()) {
            Point next = pIt.next();
            Point p = new Point(next.x, last.y, q);
            pIt.previous();
            pIt.add(p);
            pIt.next();
            p.convex = false;
            last = next;
        }
    }

    private static class MaximalElementsEventHandler
    implements Scanline.EventHandler<Point> {
        private Point.Quadrant quadrant;
        public List<Point> points = Lists.newArrayList();
        private double maximalY;
        private Comparator<Double> compare;
        private static final Comparator<Double> DBL_CMP = (d1, d2) -> Double.compare(d1, d2);

        public MaximalElementsEventHandler(Point.Quadrant quadrant) {
            this.quadrant = quadrant;
            switch (quadrant) {
                case Q1: 
                case Q2: {
                    this.compare = Collections.reverseOrder(DBL_CMP);
                    this.maximalY = Double.POSITIVE_INFINITY;
                    break;
                }
                case Q4: 
                case Q3: {
                    this.compare = DBL_CMP;
                    this.maximalY = Double.NEGATIVE_INFINITY;
                }
            }
        }

        @Override
        public void handle(Point p) {
            if (this.compare.compare(p.y, this.maximalY) > 0) {
                this.points.add(new Point(p.x, p.y, this.quadrant));
                this.maximalY = p.y;
            }
        }
    }

    private class RectangleEventHandler
    implements Scanline.EventHandler<Point> {
        private List<ElkRectangle> rects = Lists.newArrayList();
        private Point minY = null;
        private Point maxY = null;
        private double lastX;
        private ElkRectangle queued;
        private Point queuedPnt;

        private RectangleEventHandler() {
            this.lastX = Math.min(((RectilinearConvexHull)RectilinearConvexHull.this).xMin1.x, ((RectilinearConvexHull)RectilinearConvexHull.this).xMin2.x);
            this.queued = null;
            this.queuedPnt = null;
        }

        @Override
        public void handle(Point p) {
            if (this.queued != null && (p.x != this.queuedPnt.x || Point.Quadrant.isOneLeftOneRight(this.queuedPnt.quadrant, p.quadrant))) {
                this.rects.add(this.queued);
                this.lastX = this.queued.x + this.queued.width;
                this.queued = null;
                this.queuedPnt = null;
            }
            if (p.quadrant.isUpper()) {
                this.minY = p;
            } else {
                this.maxY = p;
            }
            if ((p.quadrant == Point.Quadrant.Q1 && !p.convex || p.quadrant == Point.Quadrant.Q2 && p.convex || p.quadrant == Point.Quadrant.Q3 && p.convex || p.quadrant == Point.Quadrant.Q4 && !p.convex) && this.minY != null && this.maxY != null) {
                ElkRectangle r;
                this.queued = r = new ElkRectangle(this.lastX, this.minY.y, p.x - this.lastX, this.maxY.y - this.minY.y);
                this.queuedPnt = p;
            }
        }
    }
}

