/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.ForceLayoutProvider;
import org.eclipse.elk.alg.force.options.ForceMetaDataProvider;
import org.eclipse.elk.alg.force.options.ForceModelStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class ForceOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.force";
    private static final int PRIORITY_DEFAULT = 1;
    public static final IProperty<Integer> PRIORITY = new Property(CoreOptions.PRIORITY, (Object)1);
    private static final double SPACING_NODE_NODE_DEFAULT = 80.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)80.0);
    private static final double SPACING_EDGE_LABEL_DEFAULT = 5.0;
    public static final IProperty<Double> SPACING_EDGE_LABEL = new Property(CoreOptions.SPACING_EDGE_LABEL, (Object)5.0);
    private static final double ASPECT_RATIO_DEFAULT = (double)1.6f;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.6f);
    private static final int RANDOM_SEED_DEFAULT = 1;
    public static final IProperty<Integer> RANDOM_SEED = new Property(CoreOptions.RANDOM_SEED, (Object)1);
    private static final boolean SEPARATE_CONNECTED_COMPONENTS_DEFAULT = true;
    public static final IProperty<Boolean> SEPARATE_CONNECTED_COMPONENTS = new Property(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, (Object)true);
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(50.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = CoreOptions.PORT_CONSTRAINTS;
    public static final IProperty<ForceModelStrategy> MODEL = ForceMetaDataProvider.MODEL;
    public static final IProperty<Double> TEMPERATURE = ForceMetaDataProvider.TEMPERATURE;
    public static final IProperty<Integer> ITERATIONS = ForceMetaDataProvider.ITERATIONS;
    public static final IProperty<Double> REPULSION = ForceMetaDataProvider.REPULSION;
    public static final IProperty<Integer> REPULSIVE_POWER = ForceMetaDataProvider.REPULSIVE_POWER;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Force").description("Force-based algorithm provided by the Eclipse Layout Kernel. Implements methods that follow physical analogies by simulating forces that move the nodes into a balanced distribution. Currently the original Eades model and the Fruchterman - Reingold model are supported.").providerFactory((IFactory)new ForceFactory()).category(ALGORITHM_ID).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.force").imagePath("images/force_layout.png").supportedFeatures(EnumSet.of(GraphFeature.MULTI_EDGES, GraphFeature.EDGE_LABELS)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.priority", (Object)1);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)80.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.edgeLabel", (Object)5.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", (Object)1.6f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.randomSeed", (Object)1);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.separateConnectedComponents", (Object)true);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.portConstraints", PORT_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.force.model", MODEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.force.temperature", TEMPERATURE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.force.iterations", ITERATIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.force.repulsion", REPULSION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.force.repulsivePower", REPULSIVE_POWER.getDefault());
    }

    public static class ForceFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            ForceLayoutProvider provider = new ForceLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

