/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class Spacings {
    private LGraph graph;
    private IProperty<Double>[][] nodeTypeSpacingOptionsHorizontal;
    private IProperty<Double>[][] nodeTypeSpacingOptionsVertical;

    public Spacings(LGraph graph) {
        this.graph = graph;
        int n = LNode.NodeType.values().length;
        this.nodeTypeSpacingOptionsHorizontal = new IProperty[n][n];
        this.nodeTypeSpacingOptionsVertical = new IProperty[n][n];
        this.precalculateNodeTypeSpacings();
    }

    private void precalculateNodeTypeSpacings() {
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LABEL, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.LABEL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.LABEL, LayeredOptions.SPACING_LABEL_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_PORT_PORT);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.LABEL, LayeredOptions.SPACING_LABEL_PORT);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_PORT_PORT);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.BIG_NODE, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LNode.NodeType.NORMAL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
    }

    private void nodeTypeSpacing(LNode.NodeType nt, IProperty<Double> spacing) {
        this.nodeTypeSpacingOptionsVertical[nt.ordinal()][nt.ordinal()] = spacing;
    }

    private void nodeTypeSpacing(LNode.NodeType nt, IProperty<Double> spacingVert, IProperty<Double> spacingHorz) {
        this.nodeTypeSpacingOptionsVertical[nt.ordinal()][nt.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsHorizontal[nt.ordinal()][nt.ordinal()] = spacingHorz;
    }

    private void nodeTypeSpacing(LNode.NodeType n1, LNode.NodeType n2, IProperty<Double> spacing) {
        this.nodeTypeSpacingOptionsVertical[n1.ordinal()][n2.ordinal()] = spacing;
        this.nodeTypeSpacingOptionsVertical[n2.ordinal()][n1.ordinal()] = spacing;
    }

    private void nodeTypeSpacing(LNode.NodeType n1, LNode.NodeType n2, IProperty<Double> spacingVert, IProperty<Double> spacingHorz) {
        this.nodeTypeSpacingOptionsVertical[n1.ordinal()][n2.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsVertical[n2.ordinal()][n1.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsHorizontal[n1.ordinal()][n2.ordinal()] = spacingHorz;
        this.nodeTypeSpacingOptionsHorizontal[n2.ordinal()][n1.ordinal()] = spacingHorz;
    }

    public double getHorizontalSpacing(LGraphElement e1, LGraphElement e2) {
        if (e1 instanceof LNode && e2 instanceof LNode) {
            return this.getHorizontalSpacing((LNode)e1, (LNode)e2);
        }
        throw new UnspecifiedSpacingException();
    }

    public double getHorizontalSpacing(LNode n1, LNode n2) {
        return this.getLocalSpacing(n1, n2, this.nodeTypeSpacingOptionsHorizontal);
    }

    public double getHorizontalSpacing(LNode.NodeType nt1, LNode.NodeType nt2) {
        return this.getLocalSpacing(nt1, nt2, this.nodeTypeSpacingOptionsHorizontal);
    }

    public double getVerticalSpacing(LNode n1, LNode n2) {
        return this.getLocalSpacing(n1, n2, this.nodeTypeSpacingOptionsVertical);
    }

    public double getVerticalSpacing(LNode.NodeType nt1, LNode.NodeType nt2) {
        return this.getLocalSpacing(nt1, nt2, this.nodeTypeSpacingOptionsVertical);
    }

    private double getLocalSpacing(LNode n1, LNode n2, IProperty<Double>[][] nodeTypeSpacingMapping) {
        LNode.NodeType t1 = n1.getType();
        LNode.NodeType t2 = n2.getType();
        IProperty<Double> layoutOption = nodeTypeSpacingMapping[t1.ordinal()][t2.ordinal()];
        Double s1 = Spacings.getIndividualOrDefault(n1, layoutOption);
        Double s2 = Spacings.getIndividualOrDefault(n2, layoutOption);
        return Math.max(s1, s2);
    }

    private double getLocalSpacing(LNode.NodeType nt1, LNode.NodeType nt2, IProperty<Double>[][] nodeTypeSpacingMapping) {
        IProperty<Double> layoutOption = nodeTypeSpacingMapping[nt1.ordinal()][nt2.ordinal()];
        return (Double)this.graph.getProperty(layoutOption);
    }

    public static <T> T getIndividualOrDefault(LNode node, IProperty<T> property) {
        IPropertyHolder individualSpacings;
        Object result = null;
        if (node.hasProperty(LayeredOptions.SPACING_INDIVIDUAL_OVERRIDE) && (individualSpacings = (IPropertyHolder)node.getProperty(LayeredOptions.SPACING_INDIVIDUAL_OVERRIDE)).hasProperty(property)) {
            result = individualSpacings.getProperty(property);
        }
        if (result == null) {
            result = node.getGraph().getProperty(property);
        }
        return (T)result;
    }

    public static class UnspecifiedSpacingException
    extends RuntimeException {
        private static final long serialVersionUID = 1609767701465615319L;

        public UnspecifiedSpacingException() {
        }

        public UnspecifiedSpacingException(String msg) {
            super(msg);
        }
    }
}

