/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p4nodes.InteractiveNodePlacer;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p4nodes.NetworkSimplexPlacer;
import org.eclipse.elk.alg.layered.p4nodes.SimpleNodePlacer;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKNodePlacer;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;

public enum NodePlacementStrategy implements ILayoutPhaseFactory<LayeredPhases, LGraph>
{
    SIMPLE,
    INTERACTIVE,
    LINEAR_SEGMENTS,
    BRANDES_KOEPF,
    NETWORK_SIMPLEX;


    public ILayoutPhase<LayeredPhases, LGraph> create() {
        switch (this) {
            case SIMPLE: {
                return new SimpleNodePlacer();
            }
            case INTERACTIVE: {
                return new InteractiveNodePlacer();
            }
            case LINEAR_SEGMENTS: {
                return new LinearSegmentsNodePlacer();
            }
            case BRANDES_KOEPF: {
                return new BKNodePlacer();
            }
            case NETWORK_SIMPLEX: {
                return new NetworkSimplexPlacer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the node placer " + this.toString());
    }
}

