/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import java.util.Set;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.cellsystem.ContainerArea;
import org.eclipse.elk.core.util.nodespacing.cellsystem.GridContainerCell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.StripContainerCell;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.NodeLabelLocation;

public final class NodeLabelCellCreator {
    private NodeLabelCellCreator() {
    }

    public static void createNodeLabelCells(NodeContext nodeContext, boolean onlyInside) {
        NodeLabelCellCreator.createNodeLabelCellContainers(nodeContext, onlyInside);
        nodeContext.node.getLabels().forEach(label -> NodeLabelCellCreator.handleNodeLabel(nodeContext, label, onlyInside));
    }

    private static void handleNodeLabel(NodeContext nodeContext, GraphAdapters.LabelAdapter<?> label, boolean onlyInside) {
        Set labelPlacement = label.hasProperty(CoreOptions.NODE_LABELS_PLACEMENT) ? (Set)label.getProperty(CoreOptions.NODE_LABELS_PLACEMENT) : nodeContext.nodeLabelPlacement;
        NodeLabelLocation labelLocation = NodeLabelLocation.fromNodeLabelPlacement(labelPlacement);
        if (labelLocation == NodeLabelLocation.UNDEFINED) {
            return;
        }
        if (onlyInside && !labelLocation.isInsideLocation()) {
            return;
        }
        NodeLabelCellCreator.retrieveNodeLabelCell(nodeContext, labelLocation).addLabel(label);
    }

    private static void createNodeLabelCellContainers(NodeContext nodeContext, boolean onlyInside) {
        boolean symmetry = !nodeContext.sizeOptions.contains((Object)SizeOptions.ASYMMETRICAL);
        boolean tabularNodeLabels = nodeContext.sizeOptions.contains((Object)SizeOptions.FORCE_TABULAR_NODE_LABELS);
        nodeContext.insideNodeLabelContainer = new GridContainerCell(tabularNodeLabels, symmetry, nodeContext.labelCellSpacing);
        if (nodeContext.nodeLabelsPadding != null) {
            nodeContext.insideNodeLabelContainer.getPadding().copy(nodeContext.nodeLabelsPadding);
        }
        nodeContext.nodeContainerMiddleRow.setCell(ContainerArea.CENTER, nodeContext.insideNodeLabelContainer);
        if (!onlyInside) {
            StripContainerCell northContainer = new StripContainerCell(StripContainerCell.Strip.HORIZONTAL, symmetry, nodeContext.labelCellSpacing);
            northContainer.getPadding().bottom = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.NORTH, northContainer);
            StripContainerCell southContainer = new StripContainerCell(StripContainerCell.Strip.HORIZONTAL, symmetry, nodeContext.labelCellSpacing);
            southContainer.getPadding().top = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.SOUTH, southContainer);
            StripContainerCell westContainer = new StripContainerCell(StripContainerCell.Strip.VERTICAL, symmetry, nodeContext.labelCellSpacing);
            westContainer.getPadding().right = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.WEST, westContainer);
            StripContainerCell eastContainer = new StripContainerCell(StripContainerCell.Strip.VERTICAL, symmetry, nodeContext.labelCellSpacing);
            eastContainer.getPadding().left = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.EAST, eastContainer);
        }
    }

    private static LabelCell retrieveNodeLabelCell(NodeContext nodeContext, NodeLabelLocation nodeLabelLocation) {
        LabelCell nodeLabelCell = nodeContext.nodeLabelCells.get((Object)nodeLabelLocation);
        if (nodeLabelCell == null) {
            nodeLabelCell = new LabelCell(nodeContext.labelLabelSpacing, nodeLabelLocation);
            nodeContext.nodeLabelCells.put(nodeLabelLocation, nodeLabelCell);
            if (nodeLabelLocation.isInsideLocation()) {
                nodeContext.insideNodeLabelContainer.setCell(nodeLabelLocation.getContainerRow(), nodeLabelLocation.getContainerColumn(), nodeLabelCell);
            } else {
                PortSide outsideSide = nodeLabelLocation.getOutsideSide();
                StripContainerCell containerCell = nodeContext.outsideNodeLabelContainers.get((Object)outsideSide);
                switch (outsideSide) {
                    case NORTH: 
                    case SOUTH: {
                        nodeLabelCell.setContributesToMinimumHeight(true);
                        containerCell.setCell(nodeLabelLocation.getContainerColumn(), nodeLabelCell);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        nodeLabelCell.setContributesToMinimumWidth(true);
                        containerCell.setCell(nodeLabelLocation.getContainerRow(), nodeLabelCell);
                    }
                }
            }
        }
        return nodeLabelCell;
    }
}

