/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.polyomino;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.common.compaction.options.HighLevelSortingCriterion;
import org.eclipse.elk.alg.common.compaction.options.LowLevelSortingCriterion;
import org.eclipse.elk.alg.common.compaction.options.PolyominoOptions;
import org.eclipse.elk.alg.common.compaction.options.TraversalStrategy;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorCombination;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorJitter;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorLineByLine;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorManhattan;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorMaxNormWindingInMathPosSense;
import org.eclipse.elk.alg.common.compaction.polyomino.SuccessorQuadrantsGeneric;
import org.eclipse.elk.alg.common.compaction.polyomino.structures.Direction;
import org.eclipse.elk.alg.common.compaction.polyomino.structures.PlanarGrid;
import org.eclipse.elk.alg.common.compaction.polyomino.structures.Polyomino;
import org.eclipse.elk.alg.common.compaction.polyomino.structures.Polyominoes;
import org.eclipse.elk.alg.common.compaction.polyomino.util.UniqueTriple;
import org.eclipse.elk.core.util.Pair;

public class PolyominoCompactor {
    public <P extends Polyomino> void packPolyominoes(Polyominoes<P> polyHolder) {
        BiFunction<Pair<Integer, Integer>, Polyomino, Pair<Integer, Integer>> successorBasedOnCost;
        List<P> polys = polyHolder.getPolyominoes();
        PlanarGrid grid = polyHolder.getGrid();
        switch ((LowLevelSortingCriterion)((Object)polyHolder.getProperty(PolyominoOptions.POLYOMINO_LOW_LEVEL_SORT))) {
            case BY_SIZE: {
                polys.sort(new MinPerimeterComparator().reversed());
                break;
            }
            default: {
                polys.sort(new MinPerimeterComparatorWithShape().reversed());
            }
        }
        switch ((HighLevelSortingCriterion)((Object)polyHolder.getProperty(PolyominoOptions.POLYOMINO_HIGH_LEVEL_SORT))) {
            case CORNER_CASES_THAN_SINGLE_SIDE_LAST: {
                polys.sort(new MinNumOfExtensionsComparator());
                polys.sort(new SingleExtensionSideGreaterThanRestComparator());
                polys.sort(new CornerCasesGreaterThanRestComparator());
                break;
            }
            default: {
                polys.sort(new MinNumOfExtensionsComparator());
                polys.sort(new MinNumOfExtensionDirectionsComparator());
            }
        }
        switch ((TraversalStrategy)((Object)polyHolder.getProperty(PolyominoOptions.POLYOMINO_TRAVERSAL_STRATEGY))) {
            case SPIRAL: {
                successorBasedOnCost = new SuccessorMaxNormWindingInMathPosSense();
                break;
            }
            case LINE_BY_LINE: {
                successorBasedOnCost = new SuccessorLineByLine();
                break;
            }
            case MANHATTAN: {
                successorBasedOnCost = new SuccessorManhattan();
                break;
            }
            case JITTER: {
                successorBasedOnCost = new SuccessorJitter();
                break;
            }
            case QUADRANTS_MANHATTAN: {
                successorBasedOnCost = new SuccessorQuadrantsGeneric(new SuccessorManhattan());
                break;
            }
            case QUADRANTS_LINE_BY_LINE: {
                successorBasedOnCost = new SuccessorQuadrantsGeneric(new SuccessorLineByLine());
                break;
            }
            case COMBINE_LINE_BY_LINE_MANHATTAN: {
                successorBasedOnCost = new SuccessorCombination(new SuccessorQuadrantsGeneric(new SuccessorLineByLine()), new SuccessorQuadrantsGeneric(new SuccessorManhattan()));
                break;
            }
            case COMBINE_JITTER_MANHATTAN: {
                successorBasedOnCost = new SuccessorCombination(new SuccessorQuadrantsGeneric(new SuccessorJitter()), new SuccessorQuadrantsGeneric(new SuccessorManhattan()));
                break;
            }
            default: {
                successorBasedOnCost = new SuccessorQuadrantsGeneric(new SuccessorJitter());
            }
        }
        for (Polyomino poly : polys) {
            int offX = 0;
            int offY = 0;
            Pair<Integer, Integer> next = new Pair<Integer, Integer>((Object)offX, (Object)offY);
            while (grid.intersectsWithCenterBased(poly, offX, offY)) {
                next = successorBasedOnCost.apply(next, poly);
                offX = (Integer)next.getFirst();
                offY = (Integer)next.getSecond();
            }
            grid.addFilledCellsFrom(poly, offX, offY);
        }
    }

    private class CornerCasesGreaterThanRestComparator
    implements Comparator<Polyomino> {
        private CornerCasesGreaterThanRestComparator() {
        }

        @Override
        public int compare(Polyomino o1, Polyomino o2) {
            int numDir2;
            Function<UniqueTriple, Direction> detectDirections = polyExt -> (Direction)((Object)((Object)polyExt.getFirst()));
            Set dirSet = o1.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet());
            int numDir1 = dirSet.size();
            int n = numDir1 = numDir1 == 2 ? 1 : 0;
            if (numDir1 == 1 && dirSet.parallelStream().filter(x -> x.isHorizontal()).collect(Collectors.counting()) % 2L == 0L) {
                numDir1 = 0;
            }
            int n2 = numDir2 = (numDir2 = (dirSet = o2.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet())).size()) == 2 ? 1 : 0;
            if (numDir2 == 1 && dirSet.parallelStream().filter(x -> x.isHorizontal()).collect(Collectors.counting()) % 2L == 0L) {
                numDir2 = 0;
            }
            if (numDir1 < numDir2) {
                return -1;
            }
            if (numDir1 == numDir2) {
                return 0;
            }
            return 1;
        }
    }

    private class MinNumOfExtensionDirectionsComparator
    implements Comparator<Polyomino> {
        private MinNumOfExtensionDirectionsComparator() {
        }

        @Override
        public int compare(Polyomino o1, Polyomino o2) {
            int numDir2;
            Function<UniqueTriple, Direction> detectDirections = polyExt -> (Direction)((Object)((Object)polyExt.getFirst()));
            Set dirSet = o1.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet());
            int numDir1 = dirSet.size();
            if (numDir1 < (numDir2 = (dirSet = o2.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet())).size())) {
                return -1;
            }
            if (numDir1 == numDir2) {
                return 0;
            }
            return 1;
        }
    }

    private class MinNumOfExtensionsComparator
    implements Comparator<Polyomino> {
        private MinNumOfExtensionsComparator() {
        }

        @Override
        public int compare(Polyomino o1, Polyomino o2) {
            int numExt2;
            int numExt1 = o1.getPolyominoExtensions().size();
            if (numExt1 < (numExt2 = o2.getPolyominoExtensions().size())) {
                return -1;
            }
            if (numExt1 == numExt2) {
                return 0;
            }
            return 1;
        }
    }

    private class MinPerimeterComparator
    implements Comparator<PlanarGrid> {
        private MinPerimeterComparator() {
        }

        @Override
        public int compare(PlanarGrid o1, PlanarGrid o2) {
            int halfPeri2;
            int halfPeri1 = o1.getWidth() + o1.getHeight();
            if (halfPeri1 < (halfPeri2 = o2.getWidth() + o2.getHeight())) {
                return -1;
            }
            if (halfPeri1 == halfPeri2) {
                return 0;
            }
            return 1;
        }
    }

    private class MinPerimeterComparatorWithShape
    implements Comparator<PlanarGrid> {
        private MinPerimeterComparatorWithShape() {
        }

        @Override
        public int compare(PlanarGrid o1, PlanarGrid o2) {
            int height;
            int width = o1.getWidth();
            if (width < (height = o1.getHeight())) {
                width *= width;
            } else {
                height *= height;
            }
            int val1 = width + height;
            width = o2.getWidth();
            height = o2.getHeight();
            if (width < height) {
                width *= width;
            } else {
                height *= height;
            }
            int val2 = width + height;
            if (val1 < val2) {
                return -1;
            }
            if (val1 == val2) {
                return 0;
            }
            return 1;
        }
    }

    private class SingleExtensionSideGreaterThanRestComparator
    implements Comparator<Polyomino> {
        private SingleExtensionSideGreaterThanRestComparator() {
        }

        @Override
        public int compare(Polyomino o1, Polyomino o2) {
            Function<UniqueTriple, Direction> detectDirections = polyExt -> (Direction)((Object)((Object)polyExt.getFirst()));
            Set dirSet = o1.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet());
            int numDir1 = dirSet.size();
            dirSet = o2.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet());
            int numDir2 = dirSet.size();
            numDir1 = numDir1 == 1 ? 1 : 0;
            int n = numDir2 = numDir2 == 1 ? 1 : 0;
            if (numDir1 < numDir2) {
                return -1;
            }
            if (numDir1 == numDir2) {
                return 0;
            }
            return 1;
        }
    }
}

