/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.mrtree.TreeLayoutProvider;
import org.eclipse.elk.alg.mrtree.options.MrTreeMetaDataProvider;
import org.eclipse.elk.alg.mrtree.options.OrderWeighting;
import org.eclipse.elk.alg.mrtree.options.TreeifyingOrder;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class MrTreeOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.mrtree";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(20.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 20.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)20.0);
    private static final double ASPECT_RATIO_DEFAULT = (double)1.6f;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.6f);
    private static final int PRIORITY_DEFAULT = 1;
    public static final IProperty<Integer> PRIORITY = new Property(CoreOptions.PRIORITY, (Object)1);
    private static final boolean SEPARATE_CONNECTED_COMPONENTS_DEFAULT = true;
    public static final IProperty<Boolean> SEPARATE_CONNECTED_COMPONENTS = new Property(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, (Object)true);
    private static final Direction DIRECTION_DEFAULT = Direction.DOWN;
    public static final IProperty<Direction> DIRECTION = new Property(CoreOptions.DIRECTION, (Object)DIRECTION_DEFAULT);
    public static final IProperty<Boolean> DEBUG_MODE = CoreOptions.DEBUG_MODE;
    public static final IProperty<OrderWeighting> WEIGHTING = MrTreeMetaDataProvider.WEIGHTING;
    public static final IProperty<TreeifyingOrder> SEARCH_ORDER = MrTreeMetaDataProvider.SEARCH_ORDER;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Mr. Tree").description("Tree-based algorithm provided by the Eclipse Layout Kernel. Computes a spanning tree of the input graph and arranges all nodes according to the resulting parent-children hierarchy. I pity the fool who doesn't use Mr. Tree Layout.").providerFactory((IFactory)new MrtreeFactory()).category("org.eclipse.elk.tree").melkBundleName(null).definingBundleId("org.eclipse.elk.alg.mrtree").imagePath("images/mrtree_layout.png").supportedFeatures(EnumSet.of(GraphFeature.DISCONNECTED)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)20.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", (Object)1.6f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.priority", (Object)1);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.separateConnectedComponents", (Object)true);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.direction", (Object)DIRECTION_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", DEBUG_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.weighting", WEIGHTING.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.mrtree.searchOrder", SEARCH_ORDER.getDefault());
    }

    public static class MrtreeFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            TreeLayoutProvider provider = new TreeLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

