/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.alg.layered.components.AbstractGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentsCompactor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.graph.properties.IPropertyHolder;

final class SimpleRowGraphPlacer
extends AbstractGraphPlacer {
    SimpleRowGraphPlacer() {
    }

    @Override
    public void combine(List<LGraph> components, LGraph target) {
        if (components.size() == 1) {
            LGraph source = components.get(0);
            if (source != target) {
                target.getLayerlessNodes().clear();
                this.moveGraph(target, source, 0.0, 0.0);
                target.copyProperties((IPropertyHolder)source);
                target.getPadding().copy((Spacing)source.getPadding());
                target.getSize().x = source.getSize().x;
                target.getSize().y = source.getSize().y;
            }
            return;
        }
        if (components.isEmpty()) {
            target.getLayerlessNodes().clear();
            target.getSize().x = 0.0;
            target.getSize().y = 0.0;
            return;
        }
        assert (!components.contains(target));
        for (LGraph graph : components) {
            int priority = 0;
            for (LNode node : graph.getLayerlessNodes()) {
                priority += ((Integer)node.getProperty(LayeredOptions.PRIORITY)).intValue();
            }
            graph.id = priority;
        }
        Collections.sort(components, new Comparator<LGraph>(){

            @Override
            public int compare(LGraph graph1, LGraph graph2) {
                int prio = graph2.id - graph1.id;
                if (prio == 0) {
                    double size1 = graph1.getSize().x * graph1.getSize().y;
                    double size2 = graph2.getSize().x * graph2.getSize().y;
                    return Double.compare(size1, size2);
                }
                return prio;
            }
        });
        LGraph firstComponent = components.get(0);
        target.getLayerlessNodes().clear();
        target.copyProperties((IPropertyHolder)firstComponent);
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea)) * (Double)target.getProperty(LayeredOptions.ASPECT_RATIO));
        double componentSpacing = (Double)target.getProperty(LayeredOptions.SPACING_COMPONENT_COMPONENT);
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = componentSpacing;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + componentSpacing;
                highestBox = 0.0;
            }
            KVector offset = graph.getOffset();
            this.offsetGraph(graph, xpos + offset.x, ypos + offset.y);
            offset.reset();
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + componentSpacing;
        }
        target.getSize().x = broadestRow;
        target.getSize().y = ypos + highestBox;
        if (((Boolean)firstComponent.getProperty(LayeredOptions.COMPACTION_CONNECTED_COMPONENTS)).booleanValue()) {
            ComponentsCompactor compactor = new ComponentsCompactor();
            compactor.compact(components, target.getSize(), componentSpacing);
            for (LGraph h : components) {
                h.getOffset().reset().add(compactor.getOffset());
            }
            target.getSize().reset().add(compactor.getGraphSize());
        }
        this.moveGraphs(target, components, 0.0, 0.0);
    }
}

