/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ARDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.intermediate.wrapping.GraphStats;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ICutIndexCalculator;
import org.eclipse.elk.alg.layered.intermediate.wrapping.MSDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.options.CuttingStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BreakingPointInserter
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        ICutIndexCalculator icic;
        progressMonitor.begin("Breaking Point Insertion", 1.0f);
        GraphStats gs = new GraphStats(graph);
        switch ((CuttingStrategy)((Object)graph.getProperty(LayeredOptions.WRAPPING_CUTTING_STRATEGY))) {
            case MANUAL: {
                ICutIndexCalculator.ManualCutIndexCalculator manualCutIndexCalculator = new ICutIndexCalculator.ManualCutIndexCalculator();
            }
            case ARD: {
                icic = new ARDCutIndexHeuristic();
                break;
            }
            default: {
                icic = new MSDCutIndexHeuristic();
            }
        }
        List<Integer> cuts = icic.getCutIndexes(graph, gs);
        if (((Boolean)graph.getProperty(LayeredOptions.WRAPPING_MULTI_EDGE_IMPROVE_CUTS)).booleanValue()) {
            cuts = this.improveCuts(graph, cuts);
        }
        if (cuts.isEmpty()) {
            progressMonitor.done();
            return;
        }
        int splits = this.applyCuts(graph, cuts);
        progressMonitor.done();
    }

    private Integer applyCuts(LGraph graph, List<Integer> cuts) {
        ListIterator<Layer> layerIt = graph.getLayers().listIterator();
        Iterator<Integer> cutIt = cuts.iterator();
        int idx = 0;
        int cut = cutIt.next();
        int noSplitEdges = 0;
        HashSet alreadySplit = Sets.newHashSet();
        LinkedHashSet openEdges = Sets.newLinkedHashSet();
        while (layerIt.hasNext()) {
            Layer layer = layerIt.next();
            for (LNode n : layer) {
                for (LEdge e : n.getOutgoingEdges()) {
                    openEdges.add(e);
                }
                for (LEdge e : n.getIncomingEdges()) {
                    openEdges.remove((Object)e);
                }
            }
            if (idx + 1 == cut) {
                Layer bpLayer1 = new Layer(graph);
                layerIt.add(bpLayer1);
                Layer bpLayer2 = new Layer(graph);
                layerIt.add(bpLayer2);
                for (LEdge originalEdge : openEdges) {
                    if (!alreadySplit.contains((Object)originalEdge)) {
                        ++noSplitEdges;
                        alreadySplit.add(originalEdge);
                    }
                    LNode bpStartMarker = new LNode(graph);
                    bpStartMarker.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_SIDE);
                    bpStartMarker.setLayer(bpLayer1);
                    bpStartMarker.setType(LNode.NodeType.BREAKING_POINT);
                    LPort inPortBp1 = new LPort();
                    inPortBp1.setNode(bpStartMarker);
                    inPortBp1.setSide(PortSide.WEST);
                    LPort outPortBp1 = new LPort();
                    outPortBp1.setNode(bpStartMarker);
                    outPortBp1.setSide(PortSide.EAST);
                    LNode bpEndMarker = new LNode(graph);
                    bpEndMarker.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_SIDE);
                    bpEndMarker.setLayer(bpLayer2);
                    bpEndMarker.setType(LNode.NodeType.BREAKING_POINT);
                    LPort inPortBp2 = new LPort();
                    inPortBp2.setNode(bpEndMarker);
                    inPortBp2.setSide(PortSide.WEST);
                    LPort outPortBp2 = new LPort();
                    outPortBp2.setNode(bpEndMarker);
                    outPortBp2.setSide(PortSide.EAST);
                    LEdge nodeStartEdge = new LEdge();
                    nodeStartEdge.setSource(originalEdge.getSource());
                    nodeStartEdge.setTarget(inPortBp1);
                    LEdge startEndEdge = new LEdge();
                    startEndEdge.setSource(outPortBp1);
                    startEndEdge.setTarget(inPortBp2);
                    originalEdge.setSource(outPortBp2);
                    BPInfo bpi = new BPInfo(bpStartMarker, bpEndMarker, nodeStartEdge, startEndEdge, originalEdge);
                    bpStartMarker.setProperty(InternalProperties.BREAKING_POINT_INFO, bpi);
                    bpEndMarker.setProperty(InternalProperties.BREAKING_POINT_INFO, bpi);
                    LNode prevNode = nodeStartEdge.getSource().getNode();
                    if (prevNode.getType() != LNode.NodeType.BREAKING_POINT) continue;
                    BPInfo bpiPrev = (BPInfo)prevNode.getProperty(InternalProperties.BREAKING_POINT_INFO);
                    bpiPrev.next = bpi;
                    bpi.prev = bpiPrev;
                }
                if (!cutIt.hasNext()) break;
                cut = cutIt.next();
            }
            ++idx;
        }
        return noSplitEdges;
    }

    private List<Integer> improveCuts(LGraph graph, List<Integer> cuts) {
        ArrayList improvedCuts = Lists.newArrayList();
        ArrayList ccuts = Lists.newArrayList();
        Cut lastCut = null;
        for (Integer cutIdx : cuts) {
            Cut cut = new Cut(cutIdx);
            ccuts.add(cut);
            if (lastCut != null) {
                cut.prev = lastCut;
                lastCut.suc = cut;
            }
            lastCut = cut;
        }
        int[] spans = this.computeEdgeSpans(graph);
        int i = 0;
        while (i < ccuts.size()) {
            Cut lCut = null;
            Cut rCut = ((Cut)ccuts.get(0)).selfOrNext();
            Cut bestCut = null;
            double bestScore = Double.POSITIVE_INFINITY;
            int idx = 1;
            while (idx < graph.getLayers().size()) {
                int dist;
                Cut hit;
                int lDist;
                int rDist = rCut != null ? Math.abs(rCut.index - idx) : Math.abs(idx - lCut.index) + 1;
                int n = lDist = lCut != null ? Math.abs(idx - lCut.index) : rDist + 1;
                if (lDist < rDist) {
                    hit = lCut;
                    dist = lDist;
                } else {
                    hit = rCut;
                    dist = rDist;
                }
                double score = this.computeScore(graph, idx, spans[idx], dist);
                if (score < bestScore) {
                    bestScore = score;
                    bestCut = hit;
                    bestCut.newIndex = idx;
                }
                if (rCut != null && idx == rCut.index) {
                    lCut = rCut;
                    rCut = rCut.next();
                }
                ++idx;
            }
            if (bestCut != null) {
                improvedCuts.add(bestCut.newIndex);
                bestCut.assigned = true;
                bestCut.offset();
            }
            ++i;
        }
        Collections.sort(improvedCuts);
        return improvedCuts;
    }

    private double computeScore(LGraph graph, int index, int spans, int dist) {
        double distancePenalty = (Double)graph.getProperty(LayeredOptions.WRAPPING_MULTI_EDGE_DISTANCE_PENALTY);
        return (double)spans + Math.pow(dist, distancePenalty);
    }

    private int[] computeEdgeSpans(LGraph graph) {
        int[] spans = new int[graph.getLayers().size() + 1];
        HashSet open = Sets.newHashSet();
        int i = 0;
        for (Layer l : graph.getLayers()) {
            spans[i++] = open.size();
            for (LNode n : l.getNodes()) {
                for (LEdge e : n.getOutgoingEdges()) {
                    open.add(e);
                }
            }
            for (LNode n : l.getNodes()) {
                for (LEdge e : n.getIncomingEdges()) {
                    open.remove((Object)e);
                }
            }
        }
        return spans;
    }

    public static class BPInfo {
        public final LNode start;
        public final LNode end;
        public final LEdge nodeStartEdge;
        public final LEdge startEndEdge;
        public final LEdge originalEdge;
        public LNode startInLayerDummy;
        public LEdge startInLayerEdge;
        public LNode endInLayerDummy;
        public LEdge endInLayerEdge;
        public BPInfo prev;
        public BPInfo next;

        public BPInfo(LNode startDummy, LNode endDummy, LEdge nodeStartEdge, LEdge startEndEdge, LEdge originalEdge) {
            this.start = startDummy;
            this.end = endDummy;
            this.nodeStartEdge = nodeStartEdge;
            this.startEndEdge = startEndEdge;
            this.originalEdge = originalEdge;
        }

        public static boolean isStart(LNode n) {
            BPInfo bpi = (BPInfo)n.getProperty(InternalProperties.BREAKING_POINT_INFO);
            if (bpi != null) {
                return bpi.start == n;
            }
            return false;
        }

        public static boolean isEnd(LNode n) {
            BPInfo bpi = (BPInfo)n.getProperty(InternalProperties.BREAKING_POINT_INFO);
            if (bpi != null) {
                return bpi.end == n;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BPInfo[");
            sb.append("\n\tstart=");
            sb.append((Object)this.start);
            sb.append("\n\tend=");
            sb.append((Object)this.end);
            sb.append("\n\tnodeStartEdge=");
            sb.append((Object)this.nodeStartEdge);
            sb.append("\n\tstartEndEdge=");
            sb.append((Object)this.startEndEdge);
            sb.append("\n\toriginalEdge=");
            sb.append((Object)this.originalEdge);
            sb.append("\n\tstartInLayerDummy=");
            sb.append((Object)this.startInLayerDummy);
            sb.append("\n\tstartInLayerEdge=");
            sb.append((Object)this.startInLayerEdge);
            sb.append("\n\tendInLayerDummy=");
            sb.append((Object)this.endInLayerDummy);
            sb.append("\n\tendInLayerEdge=");
            sb.append((Object)this.endInLayerEdge);
            return sb.toString();
        }
    }

    private static class Cut {
        private int index;
        private int newIndex;
        private Cut prev;
        private Cut suc;
        private boolean assigned = false;

        Cut(int index) {
            this.index = index;
        }

        public Cut selfOrNext() {
            if (!this.assigned) {
                return this;
            }
            if (this.suc != null) {
                return this.suc.selfOrNext();
            }
            return null;
        }

        public Cut next() {
            if (this.suc != null) {
                return this.suc.selfOrNext();
            }
            return null;
        }

        public void offset() {
            if (!this.assigned) {
                throw new IllegalStateException("Cannot offset an unassigned cut.");
            }
            int offset = this.newIndex - this.index;
            this.offset(offset);
            this.offsetPrev(offset);
            this.offsetSuc(offset);
        }

        private void offset(int offset) {
            this.index += offset;
        }

        private void offsetPrev(int offset) {
            if (this.prev != null && !this.prev.assigned) {
                this.prev.offset(offset);
                this.prev.offsetPrev(offset);
            }
        }

        private void offsetSuc(int offset) {
            if (this.suc != null && !this.suc.assigned) {
                this.suc.offset(offset);
                this.suc.offsetSuc(offset);
            }
        }
    }
}

